import React from 'react'
import { Navigate, Route, Routes } from 'react-router-dom'
import Dashboard from '../../views/dashboard/Dashboard'
import AccountStatement from '../../views/accountStatement/AccountStatement'
import AuthRoute from '../../config/Auth'
import ProfitAndLoss from '../../views/ProfitAndLoss/ProfitAndLoss'
import IframeCasinonew from '../../views/IframeCasino/IframeCasinonew'
import Inplay from '../../views/inplaymatches/InPlay'
import DepositWithdrawHistory from '../../views/DepositWithdrawHistory/DepositWithdrawHistory'
import BetHistory from '../../views/betHistory/BetHistory'
import Withdrawal from '../../views/withdrawal/Withdrawal'
import Deposit from '../../views/deposit/Deposit'
import ViewDetailsPage from '../../views/matchdetails/ViewDetailsPage'
import BalanceTransfer from '../../views/balanceTransfer/BalanceTransfer'
import CopyReferCode from '../../views/copyReferCode/CopyReferCode'
import PendingBets from '../../views/pendingBetHistory/PendingBets'
import CasinoProvider from '../../views/casinoProvider/CasinoProvider'
import Profile from '../../views/profile/Profile'


// j

const AppContent = () => {
  return (
    <div>
      <Routes>
        <Route path="/" element={<Navigate to="/dashboard" />} />
        <Route path='/dashboard' element={<Dashboard />} />
        <Route path='/account-statement' element={<AuthRoute element={<AccountStatement />} />} />
        <Route path="/iframe-casino-new/:providerName?/:gameId?" element={<AuthRoute element={<IframeCasinonew />} />} />
        <Route path='/profit-loss' element={<AuthRoute element={<ProfitAndLoss />} />} />
        <Route path='/deposit-withdraw' element={<AuthRoute element={<DepositWithdrawHistory />} />} />
        <Route path='/bet-history' element={<AuthRoute element={<BetHistory />} />} />
        <Route path='/withdrawal' element={<AuthRoute element={<Withdrawal />} />} />
        <Route path='/deposit' element={<AuthRoute element={<Deposit />} />} />
        <Route path='/inplay/:gameID?' element={<AuthRoute element={<Inplay />} />} />
        <Route path="/view-details/:sportId?/:matchId?" element={<AuthRoute element={<ViewDetailsPage />} />} />
        <Route path='/balance-transfer' element={<AuthRoute element={<BalanceTransfer />} />} />
        <Route path='/referCode-copy' element={<AuthRoute element={<CopyReferCode />} />} />
        <Route path='/pending-bets' element={<AuthRoute element={<PendingBets />} />} />
        <Route path='/casino-provider/:type/:gameId?' element={<AuthRoute element={<CasinoProvider />} />} />
        <Route path='/profile' element={<AuthRoute element={<Profile />} />} />
      </Routes>
    </div>
  )
}

export default React.memo(AppContent)