import { useState } from "react";
import { IoIosEyeOff, IoIosEye } from "react-icons/io";
import { useDispatch, useSelector } from "react-redux";
import { getPromotionsOffer, login } from "../../redux/_reducers/_reducers";
import { useNavigate } from "react-router-dom";
import { RxCross2 } from "react-icons/rx";
import settings from "../../domainConfig";
import { FaRegClock } from "react-icons/fa";

const PromotionDetails = ({ showModal, setShowModal, selectedPromotion }) => {

  const { getPromotionsData } = useSelector(state => state.authentication);

  return (
    <>
      {showModal && selectedPromotion && (
        <div className="fixed inset-0 backdrop-blur-[4px] bg-black bg-opacity-50 z-50 flex justify-center items-center">
          <div className="animate-slideInFromBottom bg-white text-black w-full max-w-md overflow-hidden">
            <div className="flex justify-between text-white text-[19px] w-full items-center bg-[var(--primary)] py-[10px] px-2">
              <h2 className="text-xl font-semibold">Promotion Details</h2>
              <button
                className="text-white hover:text-gray-300 text-lg font-bold"
                onClick={() => setShowModal(false)}
              >
                ×
              </button>
            </div>
            <div className="max-h-[400px] bg-fuchsia-400 overflow-y-auto">
              <div className="mt-0 flex flex-col justify-start items-start bg-white relative pt-1">
                <div className="text-[15px] text-left font-[600] p-2 bg-[var(--primary)] w-full text-white">{selectedPromotion?.title}</div>
                <div
                  className="text-[14px] text-left leading-[1.6] text-gray-800 bg-white p-3 rounded-md offer-detail-content"
                  dangerouslySetInnerHTML={{ __html: selectedPromotion?.offer_detail }}
                />
              </div>
            </div>
          </div>
        </div>
      )}

    </>
  );
};

export default PromotionDetails;