import { useState } from "react";
import { updateInfo } from "../../redux/_reducers/_reducers";
import { useDispatch } from "react-redux";
import { toast } from "react-toastify";
import { useNavigate } from "react-router-dom";
import { RxCross2 } from "react-icons/rx";
import { FaInfoCircle } from "react-icons/fa";
import { IoIosEye, IoIosEyeOff } from "react-icons/io";

function ResetPassword({ handleClose, setTogglePassword }) {
    const dispatch = useDispatch();
    const [oldPwd, setOldPwd] = useState();
    const [newPwd, setNewPwd] = useState('');
    const [confirmPwd, setConfirmPwd] = useState('');
    const [showOldPwd, setShowOldPwd] = useState(false);
    const [showNewPwd, setShowNewPwd] = useState(false);
    const [showConfirmPwd, setShowConfirmPwd] = useState(false);
    const [isLoading, setIsLoading] = useState(false);
    const [message, setMessage] = useState('')
    const navigate = useNavigate();


    const handleFormSubmit = (e) => {
        e.preventDefault();
        if (!oldPwd || !newPwd || !confirmPwd) {
            toast.error('All fields are required.');
            return;
        }
        if (newPwd !== confirmPwd) {
            setMessage("New Password & Confirm Password doesn't Match!!");
            return;
        }
        const data = {
            "oldPassword": oldPwd,
            "newPassword": newPwd,
            "confirmNewPassword": confirmPwd
        };
        try {
            setIsLoading(true);
            dispatch(updateInfo(data))
            setTogglePassword(false);
        } catch (error) {
            toast.error('Error updating password: ' + (error.message || 'An unexpected error occurred.'));
        } finally {
            setIsLoading(false);
        }
        setOldPwd('');
        setNewPwd('');
        setConfirmPwd('');
        setMessage('')
    };

    return (
        <>
            <div className="bg-white w-sm mx-auto overflow-y-auto">
                <div className='flex justify-between text-white text-[19px] md:rounded-tr-md md:rounded-tl-md w-full items-center bg-[var(--primary)] py-[10px] px-2'>
                    <div></div>
                    Reset Password
                    <RxCross2 className='text-white cursor-pointer'
                        onClick={() => handleClose()}
                    />
                </div>
                <form onSubmit={handleFormSubmit} className="p-5 space-y-4">
                    <div className="flex gap-2 justify-between items-center bg-white border-b">
                        <div className="block text-sm font-medium">Current password</div>
                        <div className="relative">
                            <input
                                type={showOldPwd ? "text" : "password"}
                                value={oldPwd}
                                onChange={(e) => setOldPwd(e.target.value)}
                                placeholder="Current password"
                                className="w-full p-2  bg-white"
                            />
                            <span
                                className="absolute right-3 top-3 cursor-pointer text-gray-500"
                                onClick={() => setShowOldPwd(!showOldPwd)}
                            >
                                {showOldPwd ? <IoIosEyeOff size={17} className="text-black" /> : <IoIosEye size={17} className="text-black" />}
                            </span>
                        </div>
                    </div>

                    <div className="flex gap-2 justify-between items-center bg-white border-b">
                        <div className="block text-sm font-medium">New password</div>
                        <div className="relative">
                            <input
                                type={showNewPwd ? "text" : "password"}
                                value={newPwd}
                                onChange={(e) => setNewPwd(e.target.value)}
                                className="w-full p-2 bg-white "
                                placeholder="New password"
                            />
                            <span
                                className="absolute right-3 top-3 cursor-pointer text-gray-500"
                                onClick={() => setShowNewPwd(!showNewPwd)}
                            >
                                {showNewPwd ? <IoIosEyeOff size={17} className="text-black" /> : <IoIosEye size={17} className="text-black" />}
                            </span>
                        </div>
                    </div>

                    <div className="flex gap-2 justify-between items-center bg-white border-b">
                        <div className="block text-sm font-medium">Confirm new password</div>
                        <div className="relative">
                            <input
                                type={showConfirmPwd ? "text" : "password"}
                                value={confirmPwd}
                                onChange={(e) => setConfirmPwd(e.target.value)}
                                className="w-full p-2 bg-white "
                                placeholder="Confirm new password" />
                            <span
                                className="absolute right-3 top-3 cursor-pointer text-gray-500"
                                onClick={() => setShowConfirmPwd(!showConfirmPwd)}
                            >
                                {showConfirmPwd ? <IoIosEyeOff size={17} className="text-black" /> : <IoIosEye size={17} className="text-black" />}
                            </span>
                        </div>
                    </div>
                    {message && <p className="text-red-500 sm:text-[14px] text-[12px] font-[500]">{message}</p>}

                    <div className="bg-blue-50 border border-blue-300 p-3 rounded-md text-[13px]">
                        <div className="flex justify-start items-center gap-1 ">
                            <FaInfoCircle className="rotate-180 text-[#2d58bb]" />
                            <h5 className="text-[#2d58bb] font-[500]">Password requirements</h5>
                        </div>
                        <ul className="list-disc py-1 text-[#2d58bb]">
                            <li>1. 6-20 characters</li>
                            <li>2. Must contain at least one English letter and one numeric</li>
                            <li>3. Allow uppercase and lowercase letters</li>
                            <li>4. Allow numbers</li>
                            <li>5. Allow special characters (@$%!#)</li>
                        </ul>
                    </div>

                    <div className="mt-4 text-center">
                        <button type="submit" className="px-4 py-2.5 text-[14px] font-[500] bg-[var(--primary)]  text-white rounded w-full hover:bg-[var(--secondary)]">Confirm</button>
                    </div>
                </form>
            </div>
        </>
    )
}

export default ResetPassword;