import AOS from "aos";
import "aos/dist/aos.css";
import React, { useState, useEffect } from "react";
import { useDispatch } from "react-redux";
import { useNavigate, useParams } from "react-router-dom";
import { getCasinoGames } from "../../redux/_reducers/_reducers";


const MiniGamesProvider = ({ setIsSideBar, isSideBar, isSidebarClose, name, type }) => {

  const handleProviderClick = () => {
    window.location.href = `/casino-provider/${type}/${name}`;
  }

  useEffect(() => {
    AOS.init();
    AOS.refresh();
  }, [isSideBar]);

  if (isSidebarClose) return null


  return (
    <>
      <div
        className={` h-full bg-[#f9fcff] w-[100px] lg:hidden left-[190px] absolute transition-all duration-300 overflow-y-auto  ease-in-out z-30`}
        onClick={(e) => e.stopPropagation()}
        data-aos="fade-right" style={{ boxShadow: 'inset 1px 0px 15px [#e4e6e9]' }}>
        <button
          onClick={() => handleProviderClick(name, type)}
          className=" flex flex-col w-full border-b gap-2  items-center overflow-y-auto py-3">
          <img alt="" className="w-[30px] h-[30px]" src="/assets/dashboard/provider-awcmjili.png" />
          <p className="md:my-0 text-sm my-1">JILI</p>
        </button>
      </div>
    </>
  );
};

export default MiniGamesProvider;