import React, { useEffect, useState } from 'react';
import { useDispatch, useSelector } from 'react-redux';
import { useParams, useNavigate } from 'react-router-dom';
import { getCasinoGames, getCasinoProvider } from '../../redux/_reducers/_reducers';

function CasinoProvider() {
    const { gameId, type } = useParams();
    const navigate = useNavigate();
    const dispatch = useDispatch();
    const [providers, setProviders] = useState([]);
    const { getCasinoProviderData, getCasinoGamesData } = useSelector(state => state.authentication);

    useEffect(() => {
        dispatch(getCasinoProvider())
    }, []);



    useEffect(() => {
        setProviders(getCasinoProviderData);
    }, [getCasinoProviderData]);



    // Fetch casino games when gameId or type changes
    useEffect(() => {
        if (gameId && type) {
            dispatch(getCasinoGames({ provider: gameId, category: type }));
        }
    }, [gameId, type, dispatch]);

    const handleProviderClick = (type, providerName) => {
        navigate(`/casino-provider/${type}/${providerName}`);
    };

    return (
        <div className='p-4'>
            {type === "casino" && providers?.length > 0 && (
                <div className="flex justify-start items-center overflow-x-auto gap-2 px-2 py-[20px] bg-white w-full">
                    {providers?.map((provider) => (
                        <button
                            key={provider.provider_name}
                            onClick={() => handleProviderClick("casino", provider.provider_name)}
                            className={`${gameId === provider.provider_name ? "bg-[var(--primary)] text-white" : "bg-gray-200"} text-black flex flex-col justify-center items-center md:text-[12px] text-[9px] px-5 py-1 rounded outline-none`}
                        >
                            <p className="md:my-0 text-sm my-1 whitespace-nowrap">{provider.provider_name}</p>
                        </button>
                    ))}
                </div>
            )}

            <h2 className="text-gray-600 uppercase text-sm font-semibold border-l-4 border-[var(--light-header)] my-2.5 px-2 lg:ml-0 ml-2">
                {gameId}
            </h2>

            <div className="grid xl:grid-cols-11 lg:grid-cols-6 md:grid-cols-5 sm:grid-cols-4 grid-cols-2 justify-start items-center overflow-hidden md:gap-8 gap-1 px-1 py-[10px]">
                {getCasinoGamesData?.length > 0 ? (
                    getCasinoGamesData.map((game, index) => (
                        <button
                            key={index}
                            onClick={() => navigate(`/iframe-casino-new/${game.provider_name}/${game.game_id}`)}
                            className="bg-secondary text-black flex gap-2 flex-col justify-center items-center  md:text-[12px] text-[9px] rounded outline-none"
                        >
                            <img alt={game.provider_name} className="border-2 border-blue-400" src={game.Image} />
                        </button>
                    ))
                ) : (
                    <p className="text-center col-span-full text-gray-500">No data available. Click a tab to load content.</p>
                )}
            </div>
        </div>
    );
}

export default CasinoProvider;