import React, { useEffect, useState } from "react";
import { CopyToClipboard } from "react-copy-to-clipboard";
import { FaCopy, FaTimes } from "react-icons/fa";
import { domainName } from "../../config/Auth";
import { signUp } from "../../redux/_reducers/_reducers";
import { useDispatch, useSelector } from "react-redux";
import settings from "../../domainConfig";
import { RxCross2 } from "react-icons/rx";
import { toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

function CopyReferCode({ handleRefer, setToggleRefer }) {

  const dispatch = useDispatch();

  // useEffect(() => {
  //   dispatch(signUp());
  // }, [])

  const { defaultSettingData } = useSelector((state) => state.authentication);
  const LogoImg = defaultSettingData?.find((item) => item.key === "site.LOGO")?.value;

  const clientUserData = JSON.parse(localStorage.getItem(`user`));
  const hostname = window.location.origin;
  const referralCode = clientUserData?.slug;
  const clipboardText = `${hostname}/register/${referralCode}`;

  const handleCopy = () => {
    toast.success("Copied Successfully!!");
    setToggleRefer(false);
  };


  return (
    <section className="">
      <div className='mt-[15px] flex gap-3 justify-between items-center px-1'>
        <div></div>
        <img src={`${settings.IMAGE_URL}${LogoImg}`} className='h-[40px]' alt='Login Logo' />
        <FaTimes className='text-black cursor-pointer' onClick={() => handleRefer()} size={16} />
      </div>
      <section className="w-full bg-white max-w-7xl mx-auto h-fit flex justify-center py-5 md:px-0 px-1">

        <div className="relative mx-auto text-center w-full afterFooter">
          <div className="bg-white mt-3 rounded-md">
            <div className="w-full py-2 text-lg font-bold text-[var(--primary)]">
              {referralCode} to Sign-Up & Get a  Referral Bonus!
            </div>
            <div className="w-full py-2 text-lg font-bold text-[var(--primary)]  overflow-x-auto">
              {hostname}/{referralCode}
            </div>
          </div>
          <div className="flex justify-center items-center mt-2">
            <CopyToClipboard text={clipboardText} onCopy={handleCopy}>
              <button className="py-2 px-4 bg-[var(--primary)] text-white rounded-md font-[600] flex justify-center items-center space-x-1 transition">
                <p>Copy</p> <FaCopy size={15} color="white" />
              </button>
            </CopyToClipboard>
          </div>

        </div>
      </section>
    </section>
  );
}

export default CopyReferCode;