import React, { useEffect, useState } from 'react'
import { CiStar } from 'react-icons/ci';
import { FaInfoCircle, FaStar } from 'react-icons/fa';
import { useDispatch, useSelector } from 'react-redux';
import { Link, useParams } from 'react-router-dom'
import { matchSeriesList } from '../../redux/_reducers/_reducers';
import moment from 'moment';



const Inplay = () => {
  const { gameID } = useParams();
  const [inplayMatches, setInplayMatches] = useState([])
  const [competitions, setCompetitions] = useState([])
  const dispatch = useDispatch()


  useEffect(() => {
    dispatch(matchSeriesList({
      limit: 100,
      pageno: 1,
      series_id: 0,
      type: "h",
    }))
    const interval = setInterval(() => {
      dispatch(matchSeriesList({
        limit: 100,
        pageno: 1,
        series_id: 0,
        type: "h",
      }));
    }, 10000);
    return () => clearInterval(interval);
  }, []);

  useEffect(() => {
    setTimeout(() => {
      const inplayMatchesLocal = (localStorage.getItem("inplayMatches") && localStorage.getItem("inplayMatches") !== undefined && localStorage.getItem("inplayMatches") !== "undefined") ? JSON.parse(localStorage.getItem("inplayMatches")).filter(game => game?.sport_id === gameID) : [];
      const competitionsLocal = (localStorage.getItem("upcomingMatches") && localStorage.getItem("upcomingMatches") !== undefined && localStorage.getItem("upcomingMatches") !== "undefined") ? JSON.parse(localStorage.getItem("upcomingMatches")).filter(game => game?.sport_id === gameID) : [];
      setInplayMatches(inplayMatchesLocal)
      setCompetitions(competitionsLocal)
    }, 1000);
  }, []);

  console.log(competitions, "222");
  console.log(inplayMatches, "111");

  return (
    <div className='md:w-[83%] md:m-auto w-full'>
      <div className=''>
        <div className='text-[rgb(37,123,36)] font-semibold pt-4'>InPlay({inplayMatches?.length})</div>

        <div className="grid md:grid-cols-12 bg-[#DDD] font-[600] text-[#2b2f35] text-[16px]">
          <div className="rounded-md flex justify-between items-center space-x-2 md:col-span-7">
            <div className="p-2 flex justify-start text-black items-center space-x-2">
              <span>Match Name</span>
              {/* <img src={sport.icon1} width={25} height={25} />
              <span>{subSport.sportName === "Soccer" ? "Football" : subSport.sportName}</span> */}
            </div>
            <div className="rounded-md p-2 flex justify-start items-center space-x-2">
              {/* <span>Matched</span> */}
            </div>
          </div>
          <div className="hidden col-span-5 md:grid grid-cols-3">
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-10 lg:pr-8 md:pr-7">
              <span>1</span>
            </div>
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-24 lg:pr-16 md:pr-12">
              <span>X</span>
            </div>
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-40 lg:pr-20 md:pr-24">
              <span>2</span>
            </div>
          </div>
        </div>

        {inplayMatches?.length > 0 ?
          inplayMatches?.map((element) => (

            <div key={element.sportId} className='pb-0.5'>


              <div className="grid md:grid-cols-12 bg-[#DDD] font-[600] text-[#2b2f35] text-[16px]">

                <div className=" flex justify-between items-center w-full md:col-span-7 py-2 px-4 gap-1 bg-white hover:bg-gray-100">

                  <div className='text-white block md:hidden text-[10px] w-14 bg-[rgb(37,123,36)] rounded-[4px] px-[9px] py-1' >
                    In-Play
                  </div>

                  <a href={`/view-details/${element?.sport_id}/${element?.match_id}`} className='text-[13px] flex flex-col gap-1 text-[var(--light-header)]'>
                    <span className=''>{element?.name}</span>
                    <span className='text-black'>{element?.start_date
                      ? moment.unix(element?.start_date).format("YYYY-MM-DD HH:mm:ss A")
                      : ""}</span>
                  </a>
                  <div className='flex justify-center items-center gap-2'>
                    <img className='w-4 h-4' src='/images/icon-fancy_inplay.png' alt="" />
                    <img className='w-4 h-4' src='/images/download.svg' alt="" />
                    {/* <img className='w-4 h-4' src='/images/p.svg' alt="" /> */}
                    <div className="px-0.5 py-0.5 bg-[var(--dark-header)] text-white text-[10px] font-bold rounded " >
                      <img className='w-3 h-3' src='/images/f-icon.svg' alt="" />
                    </div>
                  </div>

                </div>


                <div className="bg-white col-span-5 md:grid hidden md:grid-cols-7 gap-1 py-1">

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#8DD2F0]">
                    <span className="text-[14px] font-bold">
                      {Math.floor(Math.random() * 100)}
                    </span>
                    <span className="text-[12px]">
                      269.1k
                    </span>
                  </div>

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FEAFB2]">
                    <span className="text-[14px] font-bold">
                      {Math.floor(Math.random() * 100)}
                    </span>
                    <span className="text-[12px]">
                      269.1k
                    </span>
                  </div>

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FCE3E4]">
                    <span className="text-[14px] font-bold">
                      -
                    </span>
                    <span className="text-[12px]">-</span>
                  </div>

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FCE3E4]">
                    <span className="text-[14px] font-bold">
                      -
                    </span>
                    <span className="text-[12px]">
                      -
                    </span>
                  </div>

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FEAFB2]">
                    <span className="text-[14px] font-bold">
                      {Math.floor(Math.random() * 100)}
                    </span>
                    <span className="text-[12px]">
                      269.1k
                    </span>
                  </div>

                  <div className="flex flex-col text-black justify-center items-center py-1 bg-[#8DD2F0]">
                    <span className="text-[14px] font-bold">
                      {Math.floor(Math.random() * 100)}
                    </span>
                    <span className="text-[12px]">
                      269.1k
                    </span>
                  </div>

                  <div className="flex flex-col text-black justify-center cursor-pointer items-center py-1 bg-[#fffff]">
                    {/* <img src="/assets/dashboard/add-pin-s-hover.png" className="mx-2 md:block hidden" onClick={() => { handlePin(element) }}></img> */}
                  </div>
                </div>

                <div className='md:hidden flex justify-start w-full px-2 pb-1 '>
                  <div className='flex w-full'>
                    <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                      <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                    </div>
                    <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                      {Math.floor(Math.random() * 100)}

                    </div>


                  </div>
                  <div className='flex w-full '>
                    <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                      <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                    </div>
                    <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                      {Math.floor(Math.random() * 100)}

                    </div>


                  </div>
                  <div className='flex w-full '>
                    <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                      <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                    </div>
                    <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                      {Math.floor(Math.random() * 100)}

                    </div>

                  </div>

                </div>
                {/* <img src="/assets/dashboard/add-pin-s-hover.png" className="mx-2 md:block hidden" onClick={() => { handlePin(element) }}></img> */}
              </div>

            </div>
          )) :
          <div className="flex font-semibold justify-center w-full p-4 bg-white hover:bg-gray-100 items-center">
            No data found
          </div>
        }
      </div>
      <div className=''>
        <div className='text-black font-semibold py-2'>Competitions</div>

        <div className="grid md:grid-cols-12 bg-[#DDD] font-[600] text-[#2b2f35] text-[16px]">
          <div className="rounded-md flex justify-between items-center space-x-2 md:col-span-7">
            <div className="p-2 flex justify-start text-black items-center space-x-2">
              <span>Match Name</span>

              {/* <img src={sport.icon1} width={25} height={25} />
              <span>{subSport.sportName === "Soccer" ? "Football" : subSport.sportName}</span> */}
            </div>
            <div className="rounded-md p-2 flex justify-start items-center space-x-2">
              {/* <span>Matched</span> */}
            </div>
          </div>
          <div className="hidden col-span-5 md:grid grid-cols-3">
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-10 lg:pr-8 md:pr-7">
              <span>1</span>
            </div>
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-24 lg:pr-16 md:pr-12">
              <span>X</span>
            </div>
            <div className="rounded-md flex justify-center items-center space-x-2 xl:pr-40 lg:pr-20 md:pr-24">
              <span>2</span>
            </div>
          </div>
        </div>

        {
          competitions?.length > 0 ?

            competitions?.map((element) => (

              <div key={element.sportId} className='pb-0.5'>


                <div className="grid md:grid-cols-12 font-semibold w-full bg-white hover:bg-gray-100">

                  <div className="bg-white w-full md:col-span-7 flex justify-between items-center py-2 px-4 gap-1 hover:bg-gray-100">
                    {/* <button
                      onClick={() => handleStarClick(element?.eventId)}
                      className="md:block hidden"
                    >
                      {starColors ? (
                        <FaStar className="text-yellow-400" size={20} />
                      ) : (
                        <CiStar className="text-yellow-400" size={20} />
                      )}
                    </button> */}
                    <div className='text-white block md:hidden text-[10px]  w-14 bg-[rgb(37,123,36)] rounded-[4px] px-[9px] py-1' >
                      In-Play
                    </div>

                    <a href={`/view-details/${element?.sport_id}/${element?.match_id}`} className='lg:text-[13px] text-[12px] flex flex-col lg:gap-1 text-[var(--light-header)]'>
                      <span className=''>{element?.name}</span>
                      <span className='text-black'>{element?.start_date
                        ? moment.unix(element?.start_date).format("YYYY-MM-DD HH:mm:ss A")
                        : ""}</span>
                    </a>
                    <div className='flex justify-center items-center gap-2'>
                      <img className='w-4 h-4' src='/images/icon-fancy_inplay.png' alt="" />
                      <img className='w-4 h-4' src='/images/download.svg' alt="" />
                      <div className="px-0.5 py-0.5 bg-[var(--dark-header)] text-white text-[10px] font-bold rounded " >
                        <img className='w-3 h-3' src='/images/f-icon.svg' alt="" />
                      </div>
                    </div>
                    {/* <img src="/assets/dashboard/add-pin-s-hover.png" className="mx-2 md:block hidden" onClick={() => { handlePin(element) }}></img> */}

                  </div>

                  <div className="col-span-5 md:grid hidden md:grid-cols-7 gap-1 py-1">
                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#8DD2F0]">
                      <span className="text-[14px] font-bold">
                        {Math.floor(Math.random() * 100)}
                      </span>
                      <span className="text-[12px]">
                        269.1k
                      </span>
                    </div>

                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FEAFB2]">
                      <span className="text-[14px] font-bold">
                        {Math.floor(Math.random() * 100)}
                      </span>
                      <span className="text-[12px]">
                        269.1k
                      </span>
                    </div>

                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FCE3E4]">
                      <span className="text-[14px] font-bold">
                        -
                      </span>
                      <span className="text-[12px]">-</span>
                    </div>

                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FCE3E4]">
                      <span className="text-[14px] font-bold">
                        -
                      </span>
                      <span className="text-[12px]">
                        -
                      </span>
                    </div>

                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#FEAFB2]">
                      <span className="text-[14px] font-bold">
                        {Math.floor(Math.random() * 100)}
                      </span>
                      <span className="text-[12px]">
                        269.1k
                      </span>
                    </div>

                    <div className="flex flex-col text-black justify-center items-center py-1 bg-[#8DD2F0]">
                      <span className="text-[14px] font-bold">
                        {Math.floor(Math.random() * 100)}
                      </span>
                      <span className="text-[12px]">
                        269.1k
                      </span>
                    </div>

                    <div className="flex flex-col text-black justify-center cursor-pointer items-center py-1 bg-[#fffff]">
                      {/* <img src="/assets/dashboard/add-pin-s-hover.png" className="mx-2 md:block hidden" onClick={() => { handlePin(element) }}></img> */}
                    </div>
                  </div>

                  <div className='md:hidden flex justify-start w-full px-2 pb-1 '>
                    <div className='flex w-full'>
                      <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                        <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                      </div>
                      <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                        {Math.floor(Math.random() * 100)}

                      </div>


                    </div>
                    <div className='flex w-full'>
                      <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                        <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                      </div>
                      <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                        {Math.floor(Math.random() * 100)}

                      </div>


                    </div>
                    <div className='flex w-full'>
                      <div className='md:w-12 w-full h-12 bg-[#72bbef] flex justify-center items-center'>
                        <span className='font-bold'>  {Math.floor(Math.random() * 100)}</span>

                      </div>
                      <div className='md:w-12 w-full h-12 font-bold bg-[#faa9ba] flex justify-center items-center'>
                        {Math.floor(Math.random() * 100)}

                      </div>

                    </div>

                  </div>
                </div>
              </div>
            )) :
            <div className="flex font-semibold justify-center w-full p-4 bg-white hover:bg-gray-100 items-center">
              No data found
            </div>
        }
      </div>
    </div>
  )
}

export default Inplay;
