/* eslint-disable no-unused-vars */
import { useDispatch, useSelector } from "react-redux";
import { useEffect, useState } from "react";
import { AiOutlineExclamationCircle } from "react-icons/ai";
import BigSuspend from "../../component/matchdetails/bigsuspend";
import Suspend from "../../component/matchdetails/suspend";
import CALC from "../../component/matchdetails/calc";
import { useParams } from "react-router-dom";
import { toast } from "react-toastify";
import "react-toastify/dist/ReactToastify.css";
import FancyBookModal from "../../component/matchdetails/FancyBookModal";
import RightSidebarDetailsPage from "../../component/matchdetails/RightSidebarDetailsPage";
import { IoReload, IoSettings, IoTvOutline } from "react-icons/io5";
import InfoModal from "../../component/matchdetails/InfoModal";
import { FaChartLine } from "react-icons/fa6";
import BlinkingComponent from "../../component/matchdetails/blinking";
import { apiCall, httpPost, httpPostBet } from "../../config/HTTP";
import { defaultSetting, walletBalance } from "../../redux/_reducers/_reducers";
import Loader from "../../component/Loader/Loader";
import { TbMicrophoneFilled } from "react-icons/tb";
import Stakes from "../../component/stakes/Stakes";
import moment from "moment";
import { FaLongArrowAltRight } from "react-icons/fa";
import { MdOutlineCancelPresentation, MdOutlineScoreboard } from "react-icons/md";

function ViewDetailsPage() {
  const { sportId, matchId } = useParams();
  const [IsFancy, setIsFancy] = useState("tab1");
  const [stakes, setStakes] = useState(false);
  const [profitLoss, setProfitLoss] = useState(0);
  const [selectedLineIndex, setSelectedLineIndex] = useState("");
  const [bookerMakerMarket, setBookerMakerMarket] = useState([]);
  const [matchDetails, setMatchDetails] = useState({});
  const [otherMarketList, setOtherMarketList] = useState([]);
  const [userSportSettings, setUserSportSettings] = useState([]);
  const [bm, setBm] = useState([]);
  const [sessionData, setSessionData] = useState([]);
  const [sessionBetList, setSessionBetList] = useState([]);
  const [matchBetList, setMatchBetList] = useState([]);
  const [betModal, setBetModal] = useState(false);
  const [betSlipData, setBetSlipData] = useState([]);
  const [count, setCount] = useState(0);
  const [lodingBet, setLoadingBet] = useState(false);
  const [fancyBookModal, setFancyBookModal] = useState(false);
  const [fancyBookdata, setFancyBookData] = useState(false);
  const [showIframe, setShowIframe] = useState(false);
  const [showScore, setShowScore] = useState(false);
  const [handleOdds, setHandleOdds] = useState("");
  const [balance, setBalance] = useState(0);
  const [infoModal, setInfoModal] = useState(false);
  const { defaultSettingData, walletBalanceData } = useSelector(
    (state) => state.authentication
  );
  const [tv, setTv] = useState(true);
  const [scoreFrame, setScoreFrame] = useState(false);

  const handleScore = () => {
    setScoreFrame((prev) => !prev);
  };


  const handleIconClick = () => {
    setShowIframe(!showIframe);
    setTv((prev) => !prev);
  };
  const handleScoreClick = () => {
    setShowScore(!showScore);
  };
  const [value, setValue] = useState(null);

  useEffect(() => {
    if (
      walletBalanceData?.balance !== undefined &&
      walletBalanceData?.balance !== null
    ) {
      setBalance(walletBalanceData?.balance); // Set walletBalanceData into the state
    }
  }, [walletBalanceData]);

  const infoModalOpen = () => {
    setInfoModal(true);
  };

  const infoModalClose = () => {
    setInfoModal(false);
  };

  const [loadingBalance, setLoadingBalance] = useState(false);

  const handleBalanceLoading = () => {
    setLoadingBalance(true);

    setTimeout(() => {
      setLoadingBalance(false);
    }, 2000);
  };

  const [betOpenModal, setBetOpenModal] = useState(false);

  const localbalance = localStorage?.getItem("clientBalance");
  const localExposure = localStorage?.getItem("clientExposure");

  useEffect(() => {
    let isMounted = true;
    dispatch(defaultSetting());
    const fetchData = async () => {
      if (!isMounted) return;
      try {
        const responseEventDetails = await getEventDetails(matchId);
        const responseSessionDetails = await getEventSession(matchId);
      } catch (error) {
        console.error("Error fetching data:", error);
      }
    };

    const intervalId = setInterval(() => {
      fetchData();
    }, 1000);

    const getBetListData = async () => {
      try {
        await getBetList();
      } catch (error) {
        console.error("Error fetching bet list:", error);
      }
    };

    getBetListData();

    return () => {
      isMounted = false; // Mark the component as unmounted
      clearInterval(intervalId); // Clear interval on unmount
    };
  }, [matchId]);

  const getEventDetails = async (matchId) => {
    try {
      let reqData = {
        match_id: matchId,
        sport_id: sportId,
      };
      const getMatchDetails = await httpPost(`event-detals`, reqData);
      if (!getMatchDetails.error) {
        const matchDetailsData = getMatchDetails.data;
        setBookerMakerMarket(matchDetailsData?.BookerMakerMarket || []);
        setMatchDetails(matchDetailsData?.MatchDetails || {});
        setOtherMarketList(matchDetailsData?.OtherMarketList || []);
        setUserSportSettings(matchDetailsData?.UserSportSettings || []);
        setBm(matchDetailsData?.bm || []);

        const match_stack =
          matchDetailsData?.UserSportSettings?.[0]?.match_stack;

        if (match_stack) {
          // Get the current data from localStorage
          const storedMatchStack = localStorage.getItem("match_stack");

          // If the data is not already in localStorage, save it
          if (!storedMatchStack) {
            localStorage.setItem("match_stack", match_stack);
          }
        }
      } else {
        console.error("Error in fetching match details");
      }
    } catch (error) {
      console.error("Error in getEventDetails:", error);
    }
  };

  const tvData = defaultSettingData?.find(
    (item) => item.key === "site.tv_link"
  );

  useEffect(() => {
    if (tvData && tvData.value !== undefined) {
      setValue(tvData.value);
    }
  }, [tvData]);

  const getEventSession = async (matchId) => {
    try {
      let reqData = {
        match_id: matchId,
      };
      const getSessionDetails = await httpPost(`event-session`, reqData);

      if (!getSessionDetails.error) {
        const sessionDetailsData = getSessionDetails.data;
        setSessionData(sessionDetailsData || []);
      } else {
        console.error("Error in fetching session details");
      }
    } catch (error) {
      console.error("Error in getEventSession:", error);
    }
  };
  const getBetList = async () => {
    try {
      let reqData = {
        limit: 10,
        match_id: matchId,
        market_id: "0",
        fancy_id: 0,
        pageno: 1,
      };
      const getBetListData = await httpPost(`list-bt-ssn-mk`, reqData);

      if (!getBetListData.error) {
        const betData = getBetListData.data;
        setMatchBetList(betData?.MatchAndBetfair || []);
        setSessionBetList(betData?.MatchFancy || []);
      } else {
        console.error("Error in fetching session details");
      }
    } catch (error) {
      console.error("Error in getEventSession:", error);
    }
  };
  //

  const handleOpenData = (data) => {
    if (data?.odds > 0) {
      if (balance > 0) {
        setSelectedLineIndex(data?.selection_id);
        setBetModal(true);
        setBetSlipData(data);
        setCount(0);
        setHandleOdds(data?.odds);
      } else {
        toast.error("Insufficient balance to place a bet.");
      }
    } else {
      toast.error("Odds is 0 , Bet is Not Placed");
    }
  };

  const handleCloseModal = () => {
    setBetModal(false);
    setCount(0);
    setProfitLoss([]);
  };
  const handleFancyBookModal = (data) => {
    setFancyBookData(data);
    setFancyBookModal(true);
  };

  const handleCloseFancyBookModal = () => {
    setFancyBookModal(false);
  };
  const dispatch = useDispatch();
  const handlePlaceBet = async () => {
    loaderFunction();
    setLoadingBet(true);
    setCount(0);
    try {
      const betObject = {
        match_id: matchId,
        market_id: betSlipData.market_id,
        selection_id: betSlipData.selection_id,
        odds: handleOdds + "",
        stack: Number(count),
        is_back: betSlipData.is_back,
      };
      const sessionObject = {
        match_id: matchId,
        fancy_id: betSlipData.selection_id,
        run: handleOdds + "",
        size: betSlipData.size + "",
        stack: Number(count),
        is_back: betSlipData.is_back,
        fancyStatus: "A",
        sport_id: sportId,
      };

      setBetModal(false);

      let saveBetOdds;
      if (betSlipData.type === "fancy") {
        saveBetOdds = await httpPostBet("save-ssn-bet", sessionObject);
      } else {
        saveBetOdds = await httpPostBet("save-bet", betObject);
      }

      if (saveBetOdds.error === false) {
        toast.success(saveBetOdds.message);
        await getBetList();
        dispatch(walletBalance());
      } else {
        toast.error(`Bet failed: ${saveBetOdds.message || "not found"}`);
      }
    } catch (error) {
      console.error("Error placing bet:", error);
    } finally {
      setLoadingBet(false);
      setProfitLoss([]);
    }
  };

  const loaderFunction = () => {
    setLoadingBet(true);
  };
  // const whatsappData = defaultSettingData?.find((item) => item.key === "site.score_link");
  let scoreLink = defaultSettingData?.find((item) => item.key === "site.score_link")?.value;
  let scoreLinkDynamic = "";

  if (scoreLink) {
    scoreLinkDynamic = `${scoreLink}${matchId}`;
  }

  const handleTabClick = (tab) => {
    setIsFancy(tab);
  };

  const timeDifference = (date1, date2) => {
    var difference = date1 - date2;
    if (difference > 0) {
      var daysDifference = Math.floor(difference / 1000 / 60 / 60 / 24);
      difference -= daysDifference * 1000 * 60 * 60 * 24;

      var hoursDifference = Math.floor(difference / 1000 / 60 / 60);
      difference -= hoursDifference * 1000 * 60 * 60;

      var minutesDifference = Math.floor(difference / 1000 / 60);
      difference -= minutesDifference * 1000 * 60;

      var secondsDifference = Math.floor(difference / 1000);

      return (
        (daysDifference > 0 ? daysDifference + " day (s)" : "") +
        (hoursDifference > 0 ? hoursDifference + "h " : "") +
        minutesDifference +
        "m " +
        secondsDifference +
        "s "
      );
    } else {
      return null;
    }
  };

  const handleBetOpen = () => {
    setBetOpenModal((prev) => !prev);
  };

  const handleStakes = () => {
    setStakes((prev) => !prev);
  };

  useEffect(() => { const interval = setInterval(() => { getBetList() }, 5000); return () => clearInterval(interval); }, []);

  return (
    <>
      {lodingBet ? <div className="w-full  fixed inset-0 backdrop-blur-sm bg-white/10 flex justify-center items-center z-[99999]"> <Loader />  </div> :
        <div className="w-full flex lg:hidden  h-[40px] items-center p-2 justify-between mt-1 bg-[#015dab]">
          <div className="flex gap-2">
            <div
              onClick={() => {
                handleIconClick();
              }}
              className={`${!tv ? "bg-[#6cae4d]" : "bg-[#df4000]"
                } flex justify-center text-white items-center py-[3px] cursor-pointer rounded-sm space-x-1 px-1.5 text-[12px]`}
            >
              {tv ? (
                <div className="flex space-x-1 justify-center items-center">
                  <img src="/images/tv.png" className="w-4 h-3" />
                  <p className={`font-[500] ${!tv ? "text-black" : "text-white"}`}>TV</p>
                </div>
              ) : (
                <div className="flex space-x-1 justify-center items-center">
                  <img src="/images/livetv.png" className="w-4 h-3" />
                  <p className={`font-[500] ${!tv ? "text-black" : "text-white"}`}>TV</p>
                </div>
              )}
            </div>

            <div
              onClick={handleScore}
              className={`${!scoreFrame ? "bg-[#df4000]" : "bg-[#6cae4d]"
                } flex justify-center text-white items-center py-[3px] cursor-pointer rounded-sm space-x-1 px-1.5 text-[12px]`}
            >
              {scoreFrame ? (
                <>
                  <MdOutlineScoreboard size={16} className="text-black" />
                  <p className="font-[500] text-black">SCORE</p>
                </>
              ) : (
                <>
                  <MdOutlineCancelPresentation size={16} className="text-white" />
                  <p className="font-[500] text-white">SCORE</p>
                </>
              )}
            </div>


            {/* <div
              onClick={() => {
                handleScore();
              }}
              className={`${!scoreFrame ? "bg-[#df4000]" : "bg-[#6cae4d]"
                } flex justify-center items-center py-1 rounded-sm  px-2`}
            >
              SC
            </div> */}
            {/* <div onClick={()=>{handleBetOpen()}} className="bg-[#296db4] text-[14px] py-1 px-4 flex justify-center items-center rounded-sm text-white">Bets</div> */}
          </div>
          <div className="flex gap-2 x">
            {!loadingBalance ? (
              <div className="text-white text-[10px] flex flex-col">
                <span> Main INR {localbalance}</span>
                <span> Exposure {localExposure}</span>
              </div>
            ) : (
              <div className="bouncing-loader">
                <div></div>
                <div></div>
                <div></div>
              </div>
            )}
            <div
              onClick={() => {
                handleBalanceLoading();
              }}
              className="flex justify-center items-center py-[1px] px-2 border-t-[0.1px] rounded-sm bg-[#296db4]"
            >
              <IoReload className="text-white" size={16} />
            </div>
            <div className="flex justify-center items-center py-[1px] px-2 border-t-[0.1px] rounded-sm bg-[#296db4]">
              <IoSettings
                onClick={() => {
                  handleStakes();
                }}
                className="text-white"
                size={16}
              />
            </div>
          </div>
        </div>
      }

      <div className=" lg:flex block mx-auto lg:pb-0 pb-10">

        <div className="w-full relative lg:w-3/4 px-0">
          <div className=" score-tabcontent-work px-0">

            {fancyBookModal && (
              <FancyBookModal
                handleCloseFancyBookModal={handleCloseFancyBookModal}
                fancyBookdata={fancyBookdata}
              />
            )}
            {infoModal && <InfoModal infoModalClose={infoModalClose} />}
            <div className="flex flex-wrap">
              <div className="w-full lg:w-full">
                <div
                  className="flex lg:flex  h-6 items-center bg-[#27363e]"
                  style={{
                    color: "white",
                    paddingInline: "5px",
                    marginBottom: "2px",
                  }}
                  onClick={() => handleScoreClick()}
                >
                  <div className=" flex items-center h-full gap-2">
                    <TbMicrophoneFilled size={16} />
                    News
                  </div>
                  <div className="h-5 w-5  rotate-45  border-t border-r"></div>{" "}
                  {<marquee className='text-[14px]'>
                    {defaultSettingData?.find(
                      (data) => data?.key === "site.MESSAGE"
                    )?.value}
                  </marquee>}
                </div>


                {/* {matchDetails?.sportGraphic === "Y" ? (
                  <div>
                   
                      <>
                        {balance > 0 && scoreLinkDynamic ? (
                          <iframe
                            src={scoreLinkDynamic}
                            width="100%"
                            height="280"
                            frameBorder="0"
                            scrolling="no"
                            marginWidth="0"
                            allowFullScreen
                            webkitAllowFullScreen
                            mozAllowFullScreen
                            style={{ overflow: "hidden" }}
                          ></iframe>
                        ) : null}
                      </>
                  
                  </div>
                ) : null} */}

                <div>

                  <>
                    {scoreFrame && balance > 0 && scoreLinkDynamic ? (
                      <iframe
                        src={scoreLinkDynamic}
                        width="100%"
                        height="224"
                        frameBorder="0"
                        scrolling="no"
                        marginWidth="0"
                        allowFullScreen
                        webkitAllowFullScreen
                        mozAllowFullScreen
                        style={{ overflow: "hidden" }}
                      ></iframe>
                    ) : null}
                  </>

                </div>

                {matchDetails?.runner_json && (
                  <div className="md:hidden font-semibold bg-[#283f4d] text-[11px] flex justify-between items-center px-1 gap-1 py-[1px]">
                    <div className="font-serif text-white truncate">{matchDetails?.name}</div>
                    <div className="flex text-white ">{matchDetails?.start_date
                      ? moment.unix(matchDetails?.start_date).format("YYYY-MM-DD HH:mm:ss A")
                      : ""}</div>
                  </div>)}

                {matchDetails?.runner_json && (
                  <div className="detail-odds">
                    <div className="match-odds2 flex flex-wrap justify-between items-center">
                      <div className=" flex gap-2 items-center">
                        <div className="h-[30px] md:m-0  flex justify-center items-center  rounded-none md:mt-0 rounded-tr-lg bg-[#2c485a] md:bg-[#2c485a]">
                          <div className="flex px-2 flex-wrap items-center">
                            <p className=" text-[12px] text-white font-bold">
                              {matchDetails?.marketName}
                            </p>

                            <span
                              onClick={() => infoModalOpen()}
                              className="text-white block  ps-2"
                            >
                              <AiOutlineExclamationCircle
                                size={15}
                                color="currentColor"
                              />
                            </span>
                          </div>
                        </div>
                        <div className="hidden text-green-700 md:flex ">
                          {" "}
                          In-play{" "}
                        </div>
                      </div>

                      <div className="md:flex hidden flex-wrap ">
                        <div className="text-center ">
                          <div className="flex bg-[#bed5d8] px-1 text-[12px] rounded-sm items-center flex-wrap justify-center">
                            <p className="mb-0">Min / Max : </p>
                            <span>
                              {matchDetails?.marketMinStack || 0} /{" "}
                              {matchDetails?.marketMaxStack || 0}
                            </span>
                          </div>
                        </div>
                      </div>

                      <div className="md:hidden flex flex-wrap detail-oddsgroup">
                        <div className="text-center min-maxdetail">
                          <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                            <p className="mb-0">min/max</p>
                            <span>
                              {bookerMakerMarket?.marketMinStack || 0}-
                              {bookerMakerMarket?.marketMaxStack || 0}
                            </span>
                          </div>
                        </div>
                      </div>
                      <div className="lg:flex hidden gap-2">
                        <div
                          onClick={() => {
                            handleIconClick();
                          }}
                          className={`lg:flex hidden justify-center h-5 items-center gap-2 px-2 cursor-pointer ${!tv ? "bg-[#df4000]" : "bg-[#6cae4d]"
                            } rounded-md`}
                        >
                          {tv ? (
                            <img src="/images/livetv.png" className="" />
                          ) : (
                            <img src="/images/tv.png" className="" />
                          )}
                          <p className="text-[12px] font-[600]" >Live</p>
                        </div>

                        <div
                          onClick={() => {
                            handleScore();
                          }}
                          className={`${!scoreFrame ? "bg-[#df4000]" : "bg-[#6cae4d]"
                            } flex justify-center text-white items-center py-[1px] cursor-pointer rounded-sm space-x-1 px-2 text-[12px]`}
                        >
                          <MdOutlineScoreboard size={16} className={`${!scoreFrame ? "text-white" : "text-black"}`} />
                          <p className={`font-[600] ${!scoreFrame ? "text-white" : "text-black"}`}>Score</p>
                        </div>
                      </div>
                    </div>

                    {showIframe && (
                      <>
                        <div className="flex bg-black">
                          <iframe
                            // src={tvData?.value ? matchDetails?.MainTV : null}
                            src={
                              tvData?.value
                                ? `${tvData?.value}${matchId}`
                                : matchDetails?.MainTV
                            }
                            // src={matchDetails?.MainTV}
                            style={{ width: "100%", height: "280px" }}
                            title="MainTV Content"
                          />
                        </div>
                      </>
                    )}

                    <div className="all-bits-detail ">
                      <div className="detail-oddsbit flex flex-wrap items-stretch justify-between">
                        <div className="detail-oddsleft">
                          <p className="mb-0"></p>
                        </div>

                        <div className="detail-oddsright flex flex-wrap">
                          <div className="flex flex-warp detail-oddsgroup">
                            <div className="detail-odds-single text-center bg-transprent"></div>
                            <div className="detail-odds-single text-center bg-transprent"></div>
                          </div>

                          <div className="flex flex-warp detail-oddsgroup">
                            <div className="detail-odds-single  text-center">
                              <p className="mb-0 py-2">Back</p>
                            </div>
                            <div className="detail-odds-single x text-center">
                              <p className="mb-0  py-2">Lay</p>
                            </div>
                          </div>

                          <div className="flex flex-warp detail-oddsgroup">
                            <div className="text-center min-maxdetail">
                              <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                                <p className="mb-0">min/max</p>
                                <span>
                                  {matchDetails?.marketMinStack || 0}-
                                  {matchDetails?.marketMaxStack || 0}
                                </span>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>

                      <div className="relative">
                        {matchDetails && matchDetails.runner_json
                          ? matchDetails.runner_json.map((element, index) => (
                            <div
                              key={index}
                              className="detail-oddsbit flex flex-wrap items-stretch justify-between "
                            >
                              <div className="detail-oddsleft">
                                <p className="mb-0 fontSize15 font-bold">
                                  {element?.selectionName}
                                </p>
                                {parseFloat(element?.WinAndLoss) !== 0 && (
                                  <span
                                    className={`w-full flex justify-start items-center gap-1 ${parseFloat(element?.WinAndLoss) < 0
                                      ? "red-text"
                                      : "green-text"
                                      }`}
                                  >
                                    <FaLongArrowAltRight className={` ${parseFloat(element?.WinAndLoss) < 0
                                      ? "red-text"
                                      : "green-text"
                                      }`} />
                                    {parseFloat(element?.WinAndLoss)
                                      .toFixed(2)
                                      .replace(/\.?0+$/, "")}
                                  </span>
                                )}

                                {element?.WinAndLoss != null &&
                                  profitLoss[element?.selectionId] != null &&
                                  profitLoss[element?.selectionId] !== 0 &&
                                  parseFloat(
                                    element?.WinAndLoss +
                                    Number(profitLoss[element?.selectionId])
                                  ) !== 0 && (
                                    <span
                                      className={`w-full flex justify-start items-center gap-1 ${parseFloat(
                                        element?.WinAndLoss +
                                        Number(
                                          profitLoss[element?.selectionId]
                                        )
                                      ) < 0
                                        ? "red-text"
                                        : "green-text"
                                        }`}
                                    >
                                      <FaLongArrowAltRight className={` ${parseFloat(
                                        element?.WinAndLoss +
                                        Number(
                                          profitLoss[element?.selectionId]
                                        )
                                      ) < 0
                                        ? "red-text"
                                        : "green-text"
                                        }`} />
                                      (
                                      {parseFloat(
                                        element?.WinAndLoss +
                                        Number(
                                          profitLoss[element?.selectionId]
                                        )
                                      )
                                        .toFixed(2)
                                        .replace(/\.?0+$/, "")}
                                      )
                                    </span>
                                  )}
                              </div>

                              <div className="detail-oddsright flex flex-wrap items-stretch relative">
                                <div
                                  className="flex flex-warp detail-oddsgroup"
                                  style={{ flexGrow: 1 }}
                                >
                                  {element &&
                                    element.ex &&
                                    element.ex.availableToBack
                                    ? element.ex.availableToBack.map(
                                      (elementInner, index) => {
                                        if (index === 0) return null;
                                        return (
                                          <div
                                            className="detail-odds-single text-center "
                                            key={index}
                                          >
                                            <BlinkingComponent
                                              price={elementInner.price}
                                              size={elementInner.size}
                                              color=""
                                              className=""
                                            />
                                          </div>
                                        );
                                      }
                                    )
                                    : null}
                                </div>

                                <div
                                  className="flex flex-wrap detail-oddsgroup"
                                  style={{ flexGrow: 1 }}
                                >
                                  {element &&
                                    element.ex &&
                                    element.ex.availableToBack &&
                                    element.ex.availableToBack[0] ? (
                                    <div
                                      className="detail-odds-single text-center"
                                      style={{ borderRadius: "0" }}
                                      onClick={() =>
                                        handleOpenData({
                                          market_id: matchDetails?.market_id,
                                          selection_id: element?.selectionId,
                                          odds: element.ex.availableToBack[0]
                                            ?.price,
                                          is_back: "1",
                                          name: element?.selectionName,
                                          type: matchDetails?.marketName,
                                          matchDetails: matchDetails,
                                        })
                                      }
                                    >
                                      <BlinkingComponent
                                        price={
                                          element.ex.availableToBack[0].price
                                        }
                                        size={
                                          element.ex.availableToBack[0].size
                                        }
                                        color=""
                                        className=""
                                      />
                                    </div>
                                  ) : null}
                                  {element &&
                                    element.ex &&
                                    element.ex.availableToLay &&
                                    element.ex.availableToLay[0] ? (
                                    <div
                                      className="detail-odds-single text-center"
                                      style={{ borderRadius: "0" }}
                                      onClick={() =>
                                        handleOpenData({
                                          market_id: matchDetails?.market_id,
                                          selection_id: element?.selectionId,
                                          odds: element.ex.availableToLay[0]
                                            ?.price,
                                          is_back: "0",
                                          name: element?.selectionName,
                                          type: matchDetails?.marketName,
                                          matchDetails: matchDetails,
                                        })
                                      }
                                    >
                                      <BlinkingComponent
                                        price={
                                          element.ex.availableToLay[0].price
                                        }
                                        size={
                                          element.ex.availableToLay[0].size
                                        }
                                        color=""
                                        className=""
                                      />
                                    </div>
                                  ) : null}
                                </div>

                                <div
                                  className="flex flex-warp detail-oddsgroup"
                                  style={{ flexGrow: 1 }}
                                >
                                  {element &&
                                    element.ex &&
                                    element.ex.availableToLay
                                    ? element.ex.availableToLay
                                      .slice(1, 3)
                                      .map((elementInner, index) => (
                                        <>
                                          <div
                                            className="detail-odds-single text-center"
                                            key={index}
                                          >
                                            <BlinkingComponent
                                              price={elementInner.price}
                                              size={elementInner.size}
                                              color=""
                                              className=""
                                            />
                                          </div>
                                        </>
                                      ))
                                    : null}
                                </div>
                                {element.status === "ACTIVE" ? null : (
                                  <BigSuspend />
                                )}
                              </div>
                              {selectedLineIndex === element?.selectionId && (
                                <>
                                  {betModal ? (
                                    <CALC
                                      matchDetails={matchDetails}
                                      handleCloseModal={handleCloseModal}
                                      betModal={betModal}
                                      betSlipData={betSlipData}
                                      handlePlaceBet={handlePlaceBet}
                                      setCount={setCount}
                                      lodingBet={lodingBet}
                                      count={count}
                                      handleOdds={handleOdds}
                                      setHandleOdds={setHandleOdds}
                                      setProfitLoss={setProfitLoss}
                                      profitLoss={profitLoss}
                                    />
                                  ) : null}
                                </>
                              )}
                            </div>
                          ))
                          : null}

                        {matchDetails.adminMessage != "" ||
                          matchDetails.InplayStatus == "CLOSE" ||
                          matchDetails.InplayStatus == "SUSPENDED" ||
                          matchDetails.IsBetAllow == "N" ? (
                          <BigSuspend
                            GameStatus={
                              matchDetails.adminMessage != ""
                                ? matchDetails.adminMessage
                                : matchDetails.InplayStatus == "CLOSE" ||
                                  matchDetails.InplayStatus == "SUSPENDED"
                                  ? "SUSPENDED"
                                  : matchDetails.IsBetAllow == "N"
                                    ? "Bet locked"
                                    : "Bet SUSPENDED"
                            }
                          />
                        ) : null}

                        {matchDetails?.BetAllowTimeBefor > 0 &&
                          matchDetails?.start_date -
                          matchDetails?.BetAllowTimeBefore >
                          Math.floor(Date.now() / 1000) && (
                            <BigSuspend
                              GameStatus={timeDifference(
                                (matchDetails?.start_date -
                                  matchDetails?.BetAllowTimeBefore) *
                                1000,
                                Date.now()
                              )}
                            />
                          )}
                      </div>
                    </div>
                  </div>
                )}

                {bookerMakerMarket?.runner_json && (
                  <div className="detail2-odds">
                    <div className="match-odds2 flex flex-wrap justify-between items-center">
                      <div className="match-oddsleft2">
                        <ul className="matchodds-heading">
                          <li className="flex flex-wrap items-center">
                            <p className="mb-0 font-bold">
                              {bookerMakerMarket?.marketName}
                            </p>
                            <span
                              onClick={() => handleIconClick()}
                              className="ps-2"
                            >
                              <AiOutlineExclamationCircle
                                size={15}
                                color="currentColor"
                              />
                            </span>
                          </li>
                        </ul>
                      </div>
                      <div className="md:hidden flex flex-wrap detail-oddsgroup">
                        <div className="text-center min-maxdetail">
                          <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                            <p className="mb-0">min/max</p>
                            <span>
                              {bookerMakerMarket?.marketMinStack || 0}-
                              {bookerMakerMarket?.marketMaxStack || 0}
                            </span>
                          </div>
                        </div>
                      </div>
                    </div>

                    <div className="all-bits-detail2">
                      <div className="detail-oddsbit2 flex flex-wrap items-stretch justify-between">
                        <div className="detail-oddsleft2">
                          <p className="mb-0"></p>
                        </div>

                        <div
                          className="detail-oddsright2 flex items-stretch flex-wrap"
                          style={{
                            backgroundColor: "#faf8d8",
                            boxShadow: "none",
                          }}
                        >
                          <div
                            className="flex flex-warp detail-oddsgroup2"
                            style={{ flexGrow: 1 }}
                          >
                            <div className="detail-odds-single text-center bg-transprent"></div>
                            <div className="detail-odds-single text-center bg-transprent"></div>
                          </div>

                          <div
                            className="flex flex-warp detail-oddsgroup2"
                            style={{ flexGrow: 1 }}
                          >
                            <div className="detail-odds-single text-center">
                              <p className="mb-0 py-2">Back</p>
                            </div>
                            <div className="detail-odds-single text-center">
                              <p className="mb-0  py-2">Lay</p>
                            </div>
                          </div>

                          <div
                            className="flex flex-warp detail-oddsgroup2"
                            style={{ flexGrow: 1 }}
                          >
                            <div className="text-center min-maxdetail">
                              <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                                <p className="mb-0">min/max</p>
                                <span>
                                  {bookerMakerMarket?.marketMinStack || 0}-
                                  {bookerMakerMarket?.marketMaxStack || 0}
                                </span>
                              </div>
                            </div>
                          </div>
                        </div>
                      </div>
                      <div className="relative">
                        {bookerMakerMarket && bookerMakerMarket.runner_json
                          ? bookerMakerMarket.runner_json.map(
                            (element, index) => (
                              <div
                                key={index}
                                className="detail-oddsbit2 flex flex-wrap items-stretch justify-between"
                              >
                                <div className="detail-oddsleft2">
                                  <p className="mb-0 fontSize15">
                                    {element?.RunnerName}
                                  </p>
                                  {parseFloat(element?.WinAndLoss) !== 0 && (
                                    <span
                                      className={`w-full flex justify-start items-center gap-1 ${parseFloat(element?.WinAndLoss) < 0
                                        ? "red-text"
                                        : "green-text"
                                        }`}
                                    >
                                      <FaLongArrowAltRight className={` ${parseFloat(element?.WinAndLoss) < 0
                                        ? "red-text"
                                        : "green-text"
                                        }`} />
                                      {parseFloat(element?.WinAndLoss)
                                        .toFixed(2)
                                        .replace(/\.?0+$/, "")}
                                    </span>
                                  )}
                                  {element?.WinAndLoss != null &&
                                    profitLoss[element?.selectionId] !=
                                    null &&
                                    profitLoss[element?.selectionId] !== 0 &&
                                    parseFloat(
                                      element?.WinAndLoss +
                                      Number(
                                        profitLoss[element?.selectionId]
                                      )
                                    ) !== 0 && (
                                      <span
                                        className={`w-full flex justify-start items-center gap-1  ${parseFloat(
                                          element?.WinAndLoss +
                                          Number(
                                            profitLoss[
                                            element?.selectionId
                                            ]
                                          )
                                        ) < 0
                                          ? "red-text"
                                          : "green-text"
                                          }`}
                                      >
                                        <FaLongArrowAltRight className={` ${parseFloat(
                                          element?.WinAndLoss +
                                          Number(
                                            profitLoss[
                                            element?.selectionId
                                            ]
                                          )
                                        ) < 0
                                          ? "red-text"
                                          : "green-text"
                                          }`} />
                                        (
                                        {parseFloat(
                                          element?.WinAndLoss +
                                          Number(
                                            profitLoss[element?.selectionId]
                                          )
                                        )
                                          .toFixed(2)
                                          .replace(/\.?0+$/, "")}
                                        )
                                      </span>
                                    )}
                                </div>

                                <div className="detail-oddsright2 flex flex-wrap relative">
                                  <div
                                    className="flex flex-warp items-stretch detail-oddsgroup2"
                                    style={{ flexGrow: 1 }}
                                  >
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToBack
                                      ? element.ex.availableToBack.map(
                                        (elementInner, index) => {
                                          if (index === 0) return null;
                                          return (
                                            <div
                                              className="detail-odds-single2 text-center"
                                              key={index}
                                            >
                                              <BlinkingComponent
                                                price={elementInner.price}
                                                size={elementInner.size}
                                                color=""
                                                className=""
                                              />
                                            </div>
                                          );
                                        }
                                      )
                                      : null}
                                  </div>

                                  <div
                                    className="flex flex-wrap detail-oddsgroup2"
                                    style={{ flexGrow: 1 }}
                                  >
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToBack &&
                                      element.ex.availableToBack[0] ? (
                                      <div
                                        className="detail-odds-single2 text-center"
                                        style={{ borderRadius: "0" }}
                                        onClick={() =>
                                          handleOpenData({
                                            market_id:
                                              bookerMakerMarket?.market_id,
                                            selection_id:
                                              element?.selectionId,
                                            odds: element.ex
                                              .availableToBack[0]?.price,
                                            is_back: "1",
                                            name: element?.selectionName,
                                            type: bookerMakerMarket?.marketName,
                                            matchDetails: bookerMakerMarket,
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={
                                            element.ex.availableToBack[0]
                                              .price
                                          }
                                          size={
                                            element.ex.availableToBack[0]
                                              ?.size
                                          }
                                          color=""
                                          className=""
                                        />
                                      </div>
                                    ) : null}
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToLay &&
                                      element.ex.availableToLay[0] ? (
                                      <div
                                        className="detail-odds-single2 text-center"
                                        style={{ borderRadius: "0" }}
                                        onClick={() =>
                                          handleOpenData({
                                            market_id:
                                              bookerMakerMarket?.market_id,
                                            selection_id:
                                              element?.selectionId,
                                            odds: element.ex.availableToLay[0]
                                              ?.price,
                                            is_back: "0",
                                            name: element?.selectionName,
                                            type: bookerMakerMarket?.marketName,
                                            matchDetails: bookerMakerMarket,
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={
                                            element.ex.availableToLay[0].price
                                          }
                                          size={
                                            element.ex.availableToLay[0].size
                                          }
                                          color=""
                                          className=""
                                        />
                                      </div>
                                    ) : null}
                                  </div>

                                  <div
                                    className="flex flex-warp detail-oddsgroup2"
                                    style={{ flexGrow: 1 }}
                                  >
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToLay
                                      ? element.ex.availableToLay
                                        .slice(1, 3)
                                        .map((elementInner, index) => (
                                          <>
                                            <div
                                              className="detail-odds-single2 text-center"
                                              key={index}
                                            >
                                              <BlinkingComponent
                                                price={elementInner.price}
                                                size={elementInner.size}
                                                color=""
                                                className=""
                                              />
                                            </div>
                                          </>
                                        ))
                                      : null}
                                  </div>
                                  {element?.GameStatus && (
                                    <BigSuspend
                                      GameStatus={element.GameStatus}
                                    />
                                  )}
                                </div>
                                {selectedLineIndex ===
                                  element.selectionId && (
                                    <>
                                      {betModal ? (
                                        <CALC
                                          matchDetails={bookerMakerMarket}
                                          handleCloseModal={handleCloseModal}
                                          betModal={betModal}
                                          betSlipData={betSlipData}
                                          handlePlaceBet={handlePlaceBet}
                                          setCount={setCount}
                                          lodingBet={lodingBet}
                                          count={count}
                                          handleOdds={handleOdds}
                                          setHandleOdds={setHandleOdds}
                                          setProfitLoss={setProfitLoss}
                                          profitLoss={profitLoss}
                                        />
                                      ) : null}
                                    </>
                                  )}
                              </div>
                            )
                          )
                          : null}
                        {bookerMakerMarket.adminMessage != "" ||
                          bookerMakerMarket.InplayStatus == "CLOSE" ||
                          bookerMakerMarket.InplayStatus == "SUSPENDED" ||
                          bookerMakerMarket.IsBetAllow == "N" ? (
                          <BigSuspend
                            GameStatus={
                              bookerMakerMarket.adminMessage != ""
                                ? bookerMakerMarket.adminMessage
                                : bookerMakerMarket.InplayStatus == "CLOSE" ||
                                  bookerMakerMarket.InplayStatus == "SUSPENDED"
                                  ? "SUSPENDED"
                                  : bookerMakerMarket.IsBetAllow == "N"
                                    ? "Bet locked"
                                    : "Bet SUSPENDED"
                            }
                          />
                        ) : null}
                        {bookerMakerMarket?.BetAllowTimeBefore > 0 &&
                          bookerMakerMarket?.start_date -
                          bookerMakerMarket?.BetAllowTimeBefore >
                          Math.floor(Date.now() / 1000) && (
                            <BigSuspend
                              GameStatus={timeDifference(
                                (bookerMakerMarket?.start_date -
                                  bookerMakerMarket?.BetAllowTimeBefore) *
                                1000,
                                Date.now()
                              )}
                            />
                          )}
                      </div>
                    </div>
                  </div>
                )}

                {otherMarketList && otherMarketList?.length > 0
                  ? otherMarketList?.map((otherData, index) => (
                    <div key={index} className="detail-odds">
                      <div className="match-odds flex flex-wrap justify-between items-center">
                        <div className="match-oddsleft">
                          <ul className="matchodds-heading">
                            <li className="flex flex-wrap items-center font-bold">
                              <p className="mb-0">{otherData?.marketName}</p>
                              <span
                                onClick={() => handleIconClick()}
                                className="ps-2"
                              >
                                <AiOutlineExclamationCircle
                                  size={15}
                                  color="currentColor"
                                />
                              </span>
                            </li>
                          </ul>
                        </div>
                        <div className="md:hidden flex flex-wrap detail-oddsgroup">
                          <div className="text-center min-maxdetail">
                            <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                              <p className="mb-0">min/max</p>
                              <span>
                                {otherData?.marketMinStack || 0}-
                                {otherData?.marketMaxStack || 0}
                              </span>
                            </div>
                          </div>
                        </div>

                        {/* <div className="match-oddsright px-2">
                           <p className="mb-0">Matched<span>€ 28.1M</span></p>
                        </div> */}
                      </div>

                      <div className="all-bits-detail">
                        <div className="detail-oddsbit flex flex-wrap items-center justify-between">
                          <div className="detail-oddsleft">
                            <p className="mb-0"></p>
                          </div>

                          <div className="detail-oddsright flex flex-wrap">
                            <div className="flex flex-warp detail-oddsgroup">
                              <div className="detail-odds-single text-center bg-transprent"></div>
                              <div className="detail-odds-single text-center bg-transprent"></div>
                            </div>

                            <div className="flex flex-warp detail-oddsgroup">
                              <div className="detail-odds-single text-center">
                                <p className="mb-0 py-2">Back</p>
                              </div>
                              <div className="detail-odds-single text-center">
                                <p className="mb-0  py-2">Lay</p>
                              </div>
                            </div>

                            <div className="flex flex-warp detail-oddsgroup">
                              <div className="text-center min-maxdetail">
                                <div className="flex min-maxdetail2 items-center flex-wrap justify-center py-1">
                                  <p className="mb-0">min/max</p>
                                  <span>
                                    {otherData?.marketMinStack || 0}-
                                    {otherData?.marketMaxStack || 0}
                                  </span>
                                </div>
                              </div>
                            </div>
                          </div>
                        </div>
                        <div className="relative">
                          {otherData && otherData.runner_json
                            ? otherData.runner_json.map((element, index) => (
                              <div
                                key={index}
                                className="detail-oddsbit flex flex-wrap items-stretch justify-between "
                              >
                                <div className="detail-oddsleft">
                                  <p className="mb-0 fontSize15 font-bold">
                                    {element?.selectionName}
                                  </p>
                                  {parseFloat(element?.WinAndLoss) !==
                                    0 && (
                                      <span
                                        className={`w-full flex justify-start items-center gap-1 ${parseFloat(element?.WinAndLoss) < 0
                                          ? "red-text"
                                          : "green-text"
                                          }`}
                                      >
                                        <FaLongArrowAltRight className={` ${parseFloat(element?.WinAndLoss) < 0
                                          ? "red-text"
                                          : "green-text"
                                          }`} />
                                        {parseFloat(element?.WinAndLoss)
                                          .toFixed(2)
                                          .replace(/\.?0+$/, "")}
                                      </span>
                                    )}
                                  {element?.WinAndLoss != null &&
                                    profitLoss[element?.selectionId] !=
                                    null &&
                                    profitLoss[element?.selectionId] !==
                                    0 &&
                                    parseFloat(
                                      element?.WinAndLoss +
                                      Number(
                                        profitLoss[element?.selectionId]
                                      )
                                    ) !== 0 && (
                                      <span
                                        className={`${parseFloat(
                                          element?.WinAndLoss +
                                          Number(
                                            profitLoss[
                                            element?.selectionId
                                            ]
                                          )
                                        ) < 0
                                          ? "red-text"
                                          : "green-text"
                                          }`}
                                      >
                                        {" "}
                                        (
                                        {parseFloat(
                                          element?.WinAndLoss +
                                          Number(
                                            profitLoss[
                                            element?.selectionId
                                            ]
                                          )
                                        )
                                          .toFixed(2)
                                          .replace(/\.?0+$/, "")}
                                        )
                                      </span>
                                    )}
                                </div>

                                <div className="detail-oddsright flex flex-wrap relative">
                                  <div className="flex flex-warp detail-oddsgroup">
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToBack
                                      ? element.ex.availableToBack.map(
                                        (elementInner, index) => {
                                          if (index === 0) return null;
                                          return (
                                            <div
                                              className="detail-odds-single text-center"
                                              key={index}
                                            >
                                              <BlinkingComponent
                                                price={elementInner.price}
                                                size={elementInner.size}
                                                color=""
                                                className=""
                                              />
                                            </div>
                                          );
                                        }
                                      )
                                      : null}
                                  </div>

                                  <div className="flex flex-wrap detail-oddsgroup">
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToBack &&
                                      element.ex.availableToBack[0] ? (
                                      <div
                                        className="detail-odds-single text-center"
                                        style={{ borderRadius: "0" }}
                                        onClick={() =>
                                          handleOpenData({
                                            market_id: otherData?.market_id,
                                            selection_id:
                                              element?.selectionId,
                                            odds: element.ex
                                              .availableToBack[0]?.price,
                                            is_back: "1",
                                            name: element?.selectionName,
                                            type: otherData?.marketName,
                                            matchDetails: otherData,
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={
                                            element.ex.availableToBack[0]
                                              .price
                                          }
                                          size={
                                            element.ex.availableToBack[0]
                                              ?.size
                                          }
                                          color=""
                                          className=""
                                        />
                                      </div>
                                    ) : null}
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToLay &&
                                      element.ex.availableToLay[0] ? (
                                      <div
                                        className="detail-odds-single text-center"
                                        style={{ borderRadius: "0" }}
                                        onClick={() =>
                                          handleOpenData({
                                            market_id: otherData?.market_id,
                                            selection_id:
                                              element?.selectionId,
                                            odds: element.ex
                                              .availableToLay[0]?.price,
                                            is_back: "0",
                                            name: element?.selectionName,
                                            type: otherData?.marketName,
                                            matchDetails: otherData,
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={
                                            element.ex.availableToLay[0]
                                              .price
                                          }
                                          size={
                                            element.ex.availableToLay[0]
                                              .size
                                          }
                                          color=""
                                          className=""
                                        />
                                      </div>
                                    ) : null}
                                  </div>

                                  <div className="flex flex-warp detail-oddsgroup">
                                    {element &&
                                      element.ex &&
                                      element.ex.availableToLay
                                      ? element.ex.availableToLay
                                        .slice(1, 3)
                                        .map((elementInner, index) => (
                                          <>
                                            <div
                                              className="detail-odds-single text-center"
                                              key={index}
                                            >
                                              <BlinkingComponent
                                                price={elementInner.price}
                                                size={elementInner.size}
                                                color=""
                                                className=""
                                              />
                                            </div>
                                          </>
                                        ))
                                      : null}
                                  </div>
                                  {element?.GameStatus && (
                                    <BigSuspend
                                      GameStatus={element.GameStatus}
                                    />
                                  )}
                                </div>
                                {selectedLineIndex ===
                                  element.selectionId && (
                                    <>
                                      {betModal ? (
                                        <CALC
                                          matchDetails={otherData}
                                          handleCloseModal={handleCloseModal}
                                          betModal={betModal}
                                          betSlipData={betSlipData}
                                          handlePlaceBet={handlePlaceBet}
                                          setCount={setCount}
                                          lodingBet={lodingBet}
                                          count={count}
                                          handleOdds={handleOdds}
                                          setHandleOdds={setHandleOdds}
                                          setProfitLoss={setProfitLoss}
                                          profitLoss={profitLoss}
                                        />
                                      ) : null}
                                    </>
                                  )}
                              </div>
                            ))
                            : null}
                          {otherData.adminMessage != "" ||
                            otherData.InplayStatus == "CLOSE" ||
                            otherData.InplayStatus == "SUSPENDED" ||
                            otherData.IsBetAllow == "N" ? (
                            <BigSuspend
                              GameStatus={
                                otherData.adminMessage != ""
                                  ? otherData.adminMessage
                                  : otherData.InplayStatus == "CLOSE" ||
                                    otherData.InplayStatus == "SUSPENDED"
                                    ? "SUSPENDED"
                                    : otherData.IsBetAllow == "N"
                                      ? "Bet locked"
                                      : "Bet SUSPENDED"
                              }
                            />
                          ) : null}
                         
                          {otherData?.BetAllowTimeBefore != 0 && otherData?.start_date -
                            otherData?.BetAllowTimeBefore >
                            Math.floor(Date.now() / 1000) && (
                              <BigSuspend
                                GameStatus={timeDifference(
                                  (otherData?.start_date -
                                    otherData?.BetAllowTimeBefore) *
                                  1000,
                                  Date.now()
                                )}
                              />
                            )}
                        </div>
                      </div>
                    </div>
                  ))
                  : null}

                {sessionData && sessionData?.length > 0 && (
                  <div className="fancy-data">
                    <div className="flex flex-col ">
                      <div className="flex space-x-4  fancy-datawork">
                        <button
                          className={`flex justify-center items-center ${IsFancy === "tab1" ? "show" : "hide"
                            }`}
                          onClick={() => handleTabClick("tab1")}
                        >
                          <p className="mb-0">Fancy Bet</p>
                          <span className="px-1">
                            <AiOutlineExclamationCircle />
                          </span>
                        </button>
                      </div>
                      <div className="fancy mb-4">
                        {IsFancy === "tab1" && (
                          <div className="all-bits-detail ">
                            <div className="detail-oddsbit flex flex-wrap items-stretch justify-between">
                              <div className="detail-oddsleft">
                                <p className="mb-0"></p>
                              </div>

                              <div className="detail-oddsright flex flex-wrap items-center">
                                <div className="flex flex-warp detail-oddsgroup">
                                  <div className="detail-odds-single text-center bg-transprent"></div>
                                  <div className="detail-odds-single text-center bg-transprent"></div>
                                </div>

                                <div className="flex flex-warp detail-oddsgroup">
                                  <div className="detail-odds-single text-center">
                                    <p className="mb-0 py-2 pink">No</p>
                                  </div>
                                  <div className="detail-odds-single text-center">
                                    <p className="mb-0 py-2 blue">Yes</p>
                                  </div>
                                </div>

                                <div className="flex flex-warp detail-oddsgroup">
                                  <div className="text-center min-maxdetail">
                                    <div className="flex items-center flex-wrap justify-center py-1">
                                      <p className="fancy-minamax2 mb-0">
                                        min/max
                                      </p>
                                    </div>
                                  </div>
                                </div>
                              </div>
                            </div>
                            {sessionData && sessionData.length > 0
                              ? sessionData.map((data, index) => (
                                <div
                                  key={index}
                                  className="detail-oddsbit flex flex-wrap items-stretch justify-between"
                                >
                                  <div className="detail-oddsleft">
                                    <p className="mb-0 fontSize15">
                                      {data.RunnerName}
                                    </p>
                                  </div>

                                  <div className="detail-oddsright flex flex-wrap  items-stretch relative">
                                    <div
                                      className="flex flex-warp detail-oddsgroup"
                                      style={{ flexGrow: 1 }}
                                    >
                                      <div className="detail-odds-single text-center bg-transprent w-full justify-center flex">
                                        {data.scorePostion === null ? null : (
                                          <>
                                            <button
                                              className="book-btn d-md-block d-none"
                                              onClick={() =>
                                                handleFancyBookModal(
                                                  data.scorePostion
                                                )
                                              }
                                            >
                                              B
                                            </button>
                                            {/* <div
                                              className="md:hidden d-block"
                                              onClick={() =>
                                                handleFancyBookModal(
                                                  data.scorePostion
                                                )
                                              }
                                            >
                                              {" "}
                                              <AiOutlineExclamationCircle
                                                size={20}
                                              />
                                            </div> */}
                                          </>
                                        )}
                                      </div>
                                    </div>

                                    <div
                                      className="flex flex-warp detail-oddsgroup"
                                      style={{ flexGrow: 1 }}
                                    >
                                      <div
                                        className="detail-odds-single text-center pink"
                                        onClick={() =>
                                          handleOpenData({
                                            selection_id: data?.SelectionId,
                                            odds: data?.LayPrice1,
                                            size: data?.LaySize1,
                                            is_back: "0",
                                            name: data?.RunnerName,
                                            type: "fancy",
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={data.LayPrice1}
                                          size={data.LaySize1}
                                          color=""
                                          type="fancy"
                                          className=""
                                        />
                                      </div>
                                      <div
                                        className="detail-odds-single text-center blue"
                                        onClick={() =>
                                          handleOpenData({
                                            selection_id: data?.SelectionId,
                                            odds: data?.BackPrice1,
                                            size: data?.BackSize1,
                                            is_back: "1",
                                            name: data?.RunnerName,
                                            type: "fancy",
                                          })
                                        }
                                      >
                                        <BlinkingComponent
                                          price={data.BackPrice1}
                                          size={data.BackSize1}
                                          color=""
                                          type="fancy"
                                          className=""
                                        />
                                      </div>
                                    </div>
                                    <div
                                      className="flex flex-warp detail-oddsgroup"
                                      style={{ flexGrow: 1 }}
                                    >
                                      <div className="text-center min-maxdetail">
                                        <div className="flex items-center flex-wrap justify-center py-1">
                                          <p className="fancy-minmax mb-0">
                                            {data?.minStack || 0} -{" "}
                                            {data?.maxStack || 0}
                                          </p>
                                        </div>
                                      </div>
                                    </div>
                                    {data.adminMessage != "" ||
                                      data.inplayStatus == "CLOSE" ||
                                      data.inplayStatus == "SUSPENDED" ||
                                      data.IsBetAllow == "N" ? (
                                      <Suspend
                                        GameStatus={
                                          data.adminMessage != ""
                                            ? data.adminMessage
                                            : data.inplayStatus == "CLOSE" ||
                                              data.inplayStatus == "SUSPENDED"
                                              ? "SUSPENDED"
                                              : data.IsBetAllow == "N"
                                                ? "Bet locked"
                                                : "Bet SUSPENDED"
                                        }
                                      />
                                    ) : null}
                                  </div>
                                  {selectedLineIndex === data.SelectionId && (
                                    <>
                                      {betModal ? (
                                        <CALC
                                          matchDetails={sessionData}
                                          handleCloseModal={handleCloseModal}
                                          betModal={betModal}
                                          betSlipData={betSlipData}
                                          handlePlaceBet={handlePlaceBet}
                                          setCount={setCount}
                                          lodingBet={lodingBet}
                                          count={count}
                                          handleOdds={handleOdds}
                                          setHandleOdds={setHandleOdds}
                                          setProfitLoss={setProfitLoss}
                                          profitLoss={profitLoss}
                                        />
                                      ) : null}
                                    </>
                                  )}
                                </div>
                              ))
                              : null}
                          </div>
                        )}
                      </div>
                    </div>
                  </div>
                )}
                {/* <div className="detail-hide d-lg-none flex flex-column pb-5">
                           {sessionBetList && sessionBetList.length > 0 ?
                              <div>
                                 <div className="fancy-oddgreen" style={{ backgroundColor: '#e0e6e6' }}><h4>Fancy</h4></div>
                                 <div className="flex justify-between mt+2">
                                    <div className="text-start ms-1" style={{ width: '55%' }}>Back (Bet For)</div>
                                    <div className="text-center" style={{ width: '15%' }}>Odds</div>
                                    <div className="text-center" style={{ width: '15%' }}>Stake</div>
                                    <div className="text-center" style={{ width: '15%' }}>Profit</div>
                                 </div>
                                 <div>
                                    {sessionBetList && sessionBetList.length > 0 ? sessionBetList.map((element, index) => (
                                       <>
                                          <div
                                             className="flex justify-content-start items-center ps-1"
                                             style={{
                                                backgroundColor: element.is_back === "1" ? "#beddf4" : "#f3dce2",
                                                color: "#3b5160",
                                                fontSize: "10px",
                                             }}
                                          >
                                             Ref: {moment.unix(element.created_at).format("DD-MM-YYYY HH:MM:SS")}
                                          </div>
                                          <div
                                             className="flex justify-between teamname-div teamNameFancy"
                                             style={{
                                                backgroundColor: element.is_back === "1" ? "#beddf4" : "#f3dce2",
                                                border: element.is_back === "1" ? "1px solid #7dbbe9" : "1px solid #dfa3b3",
                                             }}
                                          >
                                             <div className={`flex gap-2 ${element.is_back === "1" ? "teamname-bet" : "teamname-bet2"
                                                }`}
                                                style={{ width: "55%" }}
                                             >
                                                <div className="flex gap-2">
                                                   <span className="flex items-center justify-center"
                                                      style={{
                                                         padding: "2px",
                                                         borderRadius: "5px",
                                                         color: "black",
                                                         fontWeight: "bold",
                                                         backgroundColor: element.is_back === "1" ? "#7dbbe9" : "#dfa3b3",
                                                         border: `1px solid ${element.is_back === "1" ? "#7dbbe9" : "#dfa3b3"}`,
                                                      }}
                                                   >
                                                      {element.is_back === "1" ? "Back" : "Lay"}
                                                   </span>
                                                   <span>
                                                      <div><strong>{element?.fancy_name}</strong></div>
                                                   </span>
                                                </div>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.run}/{element?.size}</span>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.stack}</span>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.profit}</span>
                                             </div>
                                          </div>
                                       </>
                                    )) : null}
                                 </div>
                              </div> : null
                           }
                           {matchBetList && matchBetList.length > 0 ?
                              <div>
                                 <div className="fancy-oddgreen" style={{ backgroundColor: '#e0e6e6' }}><h4>Odds</h4></div>
                                 <div className="flex justify-between mt-2">
                                    <div className="text-start ms-1" style={{ width: '55%' }}>Back (Bet For)</div>
                                    <div className="text-center" style={{ width: '15%' }}>Odds</div>
                                    <div className="text-center" style={{ width: '15%' }}>Stake</div>
                                    <div className="text-center" style={{ width: '15%' }}>Profit</div>
                                 </div>
                                 <div>
                                    {matchBetList && matchBetList.length > 0 ? matchBetList.map((element, index) => (
                                       <>
                                          <div
                                             className="flex ps-1 justify-content-start items-center"
                                             style={{
                                                backgroundColor: element.is_back === "1" ? "#beddf4" : "#f3dce2",
                                                color: "#3b5160",
                                                fontSize: "10px",
                                             }}
                                          >
                                             Ref: {moment.unix(element.created_at).format("DD-MM-YYYY HH:MM:SS")}
                                          </div>
                                          <div
                                             className="flex justify-between teamname-div teamNameFancy"
                                             style={{
                                                backgroundColor: element.is_back === "1" ? "#beddf4" : "#f3dce2",
                                                border: element.is_back === "1" ? "1px solid #7dbbe9" : "1px solid #dfa3b3",
                                             }}
                                          >
                                             <div className={`flex gap-2 ${element.is_back === "1" ? "teamname-bet" : "teamname-bet2"
                                                }`}
                                                style={{ width: "55%" }}
                                             >
                                                <div className="flex gap-2">
                                                   <span className="flex items-center justify-center"
                                                      style={{
                                                         padding: "2px",
                                                         borderRadius: "5px",
                                                         color: "black",
                                                         fontWeight: "bold",
                                                         backgroundColor: element.is_back === "1" ? "#7dbbe9" : "#dfa3b3",
                                                         border: `1px solid ${element.is_back === "1" ? "#7dbbe9" : "#dfa3b3"}`,
                                                      }}
                                                   >
                                                      {element.is_back === "1" ? "Back" : "Lay"}
                                                   </span>
                                                   <span>
                                                      <div><strong>{element?.selectionName}</strong></div>
                                                      <div>({element?.marketName})</div>
                                                   </span>
                                                </div>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.odds}</span>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.stack}</span>
                                             </div>
                                             <div className="flex justify-center items-center" style={{ width: "15%" }}>
                                                <span className="text-center">{element?.p_l}</span>
                                             </div>
                                          </div>
                                       </>
                                    )) : null}
                                 </div>
                              </div> : null
                           }
                        </div> */}
              </div>
              {/* <div className="col-lg-3 score-tabbets ">
                     <RightSidebarDetailsPage MainTV={tvData?.value ? `${tvData?.value}${matchId}` : matchDetails?.MainTV} showIframe={showIframe} handleIconClick={handleIconClick} sportGraphic={matchDetails?.sportGraphic} sessionBetList={sessionBetList} matchBetList={matchBetList} />
                  </div> */}
            </div>
          </div>
        </div>
        <div className="w-full lg:w-1/4 px-0 pb-5">
          <RightSidebarDetailsPage
            MainTV={
              tvData?.value
                ? `${tvData?.value}${matchId}`
                : matchDetails?.MainTV
            }
            showIframe={showIframe}
            handleIconClick={handleIconClick}
            sportGraphic={matchDetails?.sportGraphic}
            sessionBetList={sessionBetList}
            matchBetList={matchBetList}
          />
        </div>
        {betOpenModal && (
          <div className="fixed inset-0 md:hidden  bg-white z-[9999] flex items-start justify-start">
            <div
              className=" w-full flex justify-between items-center bg-[#2a4657]"
              style={{ color: "white", padding: "5px", paddingInline: "5px" }}
            >
              Open Bets{" "}
              <div
                onClick={() => {
                  handleBetOpen();
                }}
                className="text-[12px]"
              >
                X
              </div>
            </div>
            <div className="detail-hide">
              {sessionBetList && sessionBetList.length > 0 ? (
                <div>
                  <div
                    className="fancy-oddgreen"
                    style={{ backgroundColor: "rgb(203 209 209)" }}
                  >
                    <h4>Fancy</h4>
                  </div>
                  <div className="flex justify-between">
                    <div className="text-start ms-1" style={{ width: "55%" }}>
                      Back (Bet For)
                    </div>
                    <div className="text-center" style={{ width: "15%" }}>
                      Odds
                    </div>
                    <div className="text-center" style={{ width: "15%" }}>
                      Stake
                    </div>
                    <div className="text-center" style={{ width: "15%" }}>
                      Profit
                    </div>
                  </div>
                  <div>
                    {sessionBetList && sessionBetList.length > 0
                      ? sessionBetList.map((element, index) => (
                        <>
                          <div
                            className="flex justify-start items-center ps-1"
                            style={{
                              backgroundColor:
                                element.is_back === "1"
                                  ? "#beddf4"
                                  : "#f3dce2",
                              color: "#3b5160",
                              fontSize: "10px",
                            }}
                          >
                            Ref:{" "}
                            {moment
                              .unix(element.created_at)
                              .format("DD-MM-YYYY HH:MM:SS")}
                          </div>
                          <div
                            className="flex justify-between teamname-div teamNameFancy"
                            style={{
                              backgroundColor:
                                element.is_back === "1"
                                  ? "#beddf4"
                                  : "#f3dce2",
                              border:
                                element.is_back === "1"
                                  ? "1px solid #7dbbe9"
                                  : "1px solid #dfa3b3",
                            }}
                          >
                            <div
                              className={`flex gap-2 ${element.is_back === "1"
                                ? "teamname-bet"
                                : "teamname-bet2"
                                }`}
                              style={{ width: "55%" }}
                            >
                              <div className="flex gap-2">
                                <span
                                  className="flex items-center justify-center"
                                  style={{
                                    padding: "2px",
                                    borderRadius: "5px",
                                    color: "black",
                                    fontWeight: "bold",
                                    backgroundColor:
                                      element.is_back === "1"
                                        ? "#7dbbe9"
                                        : "#dfa3b3",
                                    border: `1px solid ${element.is_back === "1"
                                      ? "#7dbbe9"
                                      : "#dfa3b3"
                                      }`,
                                  }}
                                >
                                  {element.is_back === "1" ? "Back" : "Lay"}
                                </span>
                                <span>
                                  <div>
                                    <strong>{element?.fancy_name}</strong>
                                  </div>
                                  {/* <div>({element?.marketName})</div> */}
                                </span>
                              </div>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.run}/{element?.size}
                              </span>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.stack}
                              </span>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.profit}
                              </span>
                            </div>
                          </div>
                          {/* <div className="flex justify-between teamname-div">
                                                <div className={`${element.is_back === "1" ? "teamname-bet" : "teamname-bet2"}`} style={{ width: "20%" }}><span>{element.is_back === "1" ? "Back" : "Lay"}{" "}({element?.fancy_name})</span></div>
                                                <div style={{ width: "20%" }}>Ref: {moment.unix(element.created_at).format("DD-MM-YYYY HH:MM:SS")}</div>
                                                <div className={`${element.is_back === "1" ? "teamname-bet" : "teamname-bet2"}`} style={{ width: "20%" }}><span>{element.is_back === "1" ? "Back" : "Lay"}{" "}({element?.fancy_name})</span></div>
                                                <div style={{ width: "20%" }}><span className="text-center">{element?.run}/{element?.size}</span></div>
                                                <div style={{ width: "20%" }}><span className="text-center">{element?.stack}</span></div>
                                                <div style={{ width: "20%" }}><span className="text-center">{element?.profit}</span></div>
                                            </div> */}
                        </>
                      ))
                      : null}
                  </div>
                </div>
              ) : null}
              {matchBetList && matchBetList.length > 0 ? (
                <div>
                  <div
                    className="fancy-oddgreen"
                    style={{ backgroundColor: "rgb(203 209 209)" }}
                  >
                    <h4>Odds</h4>
                  </div>
                  <div className="flex justify-between text-center">
                    <div className="text-start ms-1" style={{ width: "55%" }}>
                      Back (Bet For)
                    </div>
                    <div style={{ width: "15%" }}>Odds</div>
                    <div style={{ width: "15%" }}>Stake</div>
                    <div style={{ width: "15%" }}>Profit</div>
                  </div>
                  <div>
                    {matchBetList && matchBetList.length > 0
                      ? matchBetList.map((element, index) => (
                        <>
                          <div
                            className="flex justify-start items-center ps-1"
                            style={{
                              backgroundColor:
                                element.is_back === "1"
                                  ? "#beddf4"
                                  : "#f3dce2",
                              color: "#3b5160",
                              fontSize: "10px",
                            }}
                          >
                            Ref:{" "}
                            {moment
                              .unix(element.created_at)
                              .format("DD-MM-YYYY HH:MM:SS")}
                          </div>
                          <div
                            className="flex justify-between teamname-div teamNameFancy"
                            style={{
                              backgroundColor:
                                element.is_back === "1"
                                  ? "#beddf4"
                                  : "#f3dce2",
                              border:
                                element.is_back === "1"
                                  ? "1px solid #7dbbe9"
                                  : "1px solid #dfa3b3",
                            }}
                          >
                            <div
                              className={`flex gap-2 ${element.is_back === "1"
                                ? "teamname-bet"
                                : "teamname-bet2"
                                }`}
                              style={{ width: "55%" }}
                            >
                              <div className="flex gap-2">
                                <span
                                  className="flex items-center justify-center"
                                  style={{
                                    padding: "2px",
                                    borderRadius: "5px",
                                    color: "black",
                                    fontWeight: "bold",
                                    backgroundColor:
                                      element.is_back === "1"
                                        ? "#7dbbe9"
                                        : "#dfa3b3",
                                    border: `1px solid ${element.is_back === "1"
                                      ? "#7dbbe9"
                                      : "#dfa3b3"
                                      }`,
                                  }}
                                >
                                  {element.is_back === "1" ? "Back" : "Lay"}
                                </span>
                                <span>
                                  <div>
                                    <strong>{element?.selectionName}</strong>
                                  </div>
                                  <div>({element?.marketName})</div>
                                </span>
                              </div>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.odds}
                              </span>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.stack}
                              </span>
                            </div>
                            <div
                              className="flex justify-center items-center"
                              style={{ width: "15%" }}
                            >
                              <span className="text-center">
                                {element?.p_l}
                              </span>
                            </div>
                          </div>
                        </>
                      ))
                      : null}
                  </div>
                </div>
              ) : null}
            </div>
          </div>
        )}
        {stakes && (
          <div className="fixed inset-0 bg-black bg-opacity-50 z-[9999] flex items-center justify-center">
            <Stakes handleCross={handleStakes} />
          </div>
        )}
      </div>
    </>
  );
}

export default ViewDetailsPage;
