const { parse } = require('json2csv')
const { saveAs } = require('file-saver')

const useDownloadCsv = ({parseOpts = null}) => {
    return (data, filename) => {
        const csv = parse(data,parseOpts)
        const file = new Blob([csv], { type: 'text/csv;charset=utf-8' })
        saveAs(file, filename || 'download.csv')
    }
}

module.exports = useDownloadCsv